/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.Images;
import com.andavin.images.command.BaseCommand;
import com.andavin.images.image.CustomImage;
import com.andavin.images.legacy.LegacyImportManager;
import com.andavin.util.Scheduler;
import com.andavin.util.TimeoutMetadata;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

public class ImportCommand
extends BaseCommand {
    private static final String CONFIRM_META = "import-confirm";
    private static final long COOLDOWN = TimeUnit.MINUTES.toMillis(5L);
    private long lastRun;

    ImportCommand() {
        super("import", "images.command.import");
        this.setAliases("legacyImport");
        this.setDesc("Import and destroy all legacy images and create new ones in the new format");
        this.setUsage("/image import");
    }

    @Override
    public void execute(Player player, String label, String[] args) {
        if (TimeoutMetadata.isExpired(player, CONFIRM_META)) {
            player.sendMessage("\u00a7eAre you sure you want to import legacy images?\n\u00a77This can not be undone unless you\n\u00a7ctake a backup of your world folder.\n\u00a7eRe-type the command to confirm");
            player.setMetadata(CONFIRM_META, (MetadataValue)new TimeoutMetadata(15L, TimeUnit.SECONDS));
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastRun < COOLDOWN) {
            player.sendMessage("\u00a7cPlease wait 5 minutes before running that again.");
            return;
        }
        this.lastRun = now;
        player.sendMessage("\u00a7aImporting legacy images.\n\u00a7eThis will cause sever lag. Please wait...");
        List<CustomImage> importedImages = LegacyImportManager.importImages(Images.getImagesDirectory(), Images.getDataManager());
        Scheduler.async(() -> {
            Images.addImages(importedImages);
            player.sendMessage("\u00a7aSuccessfully imported \u00a7f" + importedImages.size() + "\u00a7a images");
        });
    }
}

